/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class FFrog
extends EntityLiving {
    private int singing = 0;
    private int jumpcount = 0;

    public FFrog(World w) {
        super(w);
        this.maxrenderdist = 48;
        this.height = 0.63f;
        this.width = 0.63f;
        this.uniquename = "OreSpawn:Frog";
        this.moveSpeed = 0.24f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(4.0f);
        this.movefrequency = 50;
        this.setExperience(3);
        this.canSwim = true;
        this.takesFallDamage = false;
        this.attackRange = 1.5f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.searchDistance = 8.0f;
        this.enable_droppedfood = true;
        this.foodsearchDistance = 12;
        this.enable_hostile = true;
        this.enableTaming(16);
    }

    public void init() {
        super.init();
        this.setSinging(false);
    }

    public boolean isFoodItem(int foodid) {
        return foodid == Items.deadbug.itemID;
    }

    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && p != null && ic == null) {
            Entity princess = null;
            princess = this.world.rand.nextBoolean() ? this.world.createEntityByName("OreSpawn:Boyfriend", this.dimension, this.posx, this.posy, this.posz) : this.world.createEntityByName("OreSpawn:Girlfriend", this.dimension, this.posx, this.posy, this.posz);
            if (princess != null) {
                princess.init();
                princess.setVarInt(21, 1 + this.world.rand.nextInt(2));
                princess.setMaxHealth(100.0f);
                princess.setOwnerName(p.myname);
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                princess.setHealth(princess.getMaxHealth());
                this.world.spawnEntityInWorld(princess);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                this.deadflag = true;
            }
        }
        return false;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e.getWidth() * e.getHeight() > 0.53f) {
            return false;
        }
        if (!this.CanProbablySeeEntity(e)) {
            return false;
        }
        return !(e instanceof FFrog);
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            if (this.singing > 0) {
                --this.singing;
                if (this.singing <= 0) {
                    this.setSinging(false);
                }
            }
            if (this.jumpcount > 0) {
                --this.jumpcount;
            }
            if (this.jumpcount == 0 && this.world.rand.nextInt(50) == 1) {
                this.jumpAround();
                this.jumpcount = 50;
            }
            if (this.world.rand.nextInt(5000) == 1 && this.getCanDespawn()) {
                this.deadflag = true;
            }
        }
        super.update(deltaT);
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) == 1) {
            return null;
        }
        this.setSinging(true);
        this.singing = 20;
        if (this.world.rand.nextInt(2) == 1) {
            return "OreSpawn:frog2";
        }
        return "OreSpawn:frog1";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public String getHurtSound() {
        return "OreSpawn:scorpion_hit";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyfrog.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
    }

    private void jumpAround() {
        this.target = null;
        this.motiony += 0.65f + Math.abs(this.world.rand.nextFloat() * 0.65f);
        this.posy += 0.25;
        float f = 0.68f + Math.abs(this.world.rand.nextFloat() * 0.75f);
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        this.motionx = (float)((double)this.motionx + (double)f * Math.sin(cdir));
        this.motionz = (float)((double)this.motionz + (double)f * Math.cos(cdir));
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Frogtexture.png");
        }
        return this.texture;
    }
}

